/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.engine.Seed;
import com.terraforged.engine.util.Variance;
import com.terraforged.engine.world.geology.DepthBuffer;
import com.terraforged.engine.world.geology.Geology;
import com.terraforged.engine.world.geology.Strata;
import com.terraforged.engine.world.geology.Stratum;
import com.terraforged.mod.api.biome.surface.MaskedSurface;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;

public class BryceSurface
implements MaskedSurface,
Stratum.Visitor<BlockState, SurfaceContext> {
    public static final int SEED_OFFSET = 12341341;
    private final Module module;
    private final Geology<BlockState> stratas;

    public BryceSurface(Seed seed) {
        Random random = new Random(seed.next());
        Variance thick = Variance.of(0.2, 0.3);
        Variance medium = Variance.of(0.1, 0.2);
        Variance thin = Variance.of(0.1, 0.2);
        this.module = Source.ridge(seed.next(), 60, 4).clamp(0.8, 0.95).map(0.0, 0.999).legacyTerrace(1.0, 0.25, 4, 0.25).mult(Source.perlin(seed.next(), 4, 1).alpha(0.05));
        this.stratas = new Geology(Source.ZERO);
        for (int i = 0; i < 3; ++i) {
            this.stratas.add(Strata.builder(seed.next(), Source.build(seed.next(), 100, 1)).add(Blocks.field_196778_fp.func_176223_P(), thin.next(random)).add(Blocks.field_150405_ch.func_176223_P(), medium.next(random)).add(Blocks.field_196778_fp.func_176223_P(), thick.next(random)).add(Blocks.field_196719_fA.func_176223_P(), thin.next(random)).add(Blocks.field_196783_fs.func_176223_P(), thin.next(random)).add(Blocks.field_150405_ch.func_176223_P(), thick.next(random)).build());
            this.stratas.add(Strata.builder(seed.next(), Source.build(seed.next(), 100, 1)).add(Blocks.field_196778_fp.func_176223_P(), thin.next(random)).add(Blocks.field_150405_ch.func_176223_P(), medium.next(random)).add(Blocks.field_196778_fp.func_176223_P(), thick.next(random)).add(Blocks.field_196783_fs.func_176223_P(), thin.next(random)).add(Blocks.field_196791_fw.func_176223_P(), thin.next(random)).add(Blocks.field_150405_ch.func_176223_P(), thick.next(random)).build());
            this.stratas.add(Strata.builder(seed.next(), Source.build(seed.next(), 100, 1)).add(Blocks.field_196778_fp.func_176223_P(), medium.next(random)).add(Blocks.field_150405_ch.func_176223_P(), thin.next(random)).add(Blocks.field_196778_fp.func_176223_P(), thick.next(random)).add(Blocks.field_196777_fo.func_176223_P(), thin.next(random)).add(Blocks.field_196791_fw.func_176223_P(), thin.next(random)).add(Blocks.field_150405_ch.func_176223_P(), thick.next(random)).build());
        }
    }

    @Override
    public void buildSurface(int x, int z, int height, float mask, SurfaceContext ctx) {
        float strength = 1.0f - ctx.cell.gradient;
        float value = this.module.getValue(x, z) * mask * strength;
        int top = (int)(value * 30.0f);
        if (top <= 0) {
            return;
        }
        ctx.pos.func_181079_c(x, height, z);
        this.stratas.getStrata(ctx.cell.biomeRegionId).downwards(x, top, z, (DepthBuffer)ctx.depthBuffer.get(), ctx, this);
    }

    @Override
    public boolean visit(int y, BlockState state, SurfaceContext ctx) {
        if (y <= 0) {
            return false;
        }
        ctx.pos.func_185336_p(ctx.surfaceY + y);
        ctx.chunk.func_177436_a((BlockPos)ctx.pos, state, false);
        return true;
    }
}

